import java.awt.*;
import java.awt.event.*;
import java.io.*;

public
class HelloApp extends Frame implements WindowListener, ActionListener
{
  TextArea textArea;
  public HelloApp ()
  {
    super();
    addWindowListener(this);
    setSize(320, 240);
    setTitle("Moja aplikacja w Javie");
    setLayout(null);
    
    textArea = new TextArea();
    textArea.setBounds(10, 50, 300, 160);
    this.add(textArea);
    
    MenuBar menuBar = new MenuBar();
    setMenuBar(menuBar);
    Menu menu = new Menu("Plik");
    menu.add(new MenuItem("Otwrz"));
    menu.add(new MenuItem("Zapisz"));
    menu.add(new MenuItem("-"));
    menu.add(new MenuItem("Zamknij"));
    menuBar.add(menu);
    
    menu.addActionListener(this);
    setVisible(true);
    textArea.setVisible(true);
  }
  public void actionPerformed(ActionEvent e)
  {
    String command = e.getActionCommand();
    if (command.equals("Zamknij")){
      System.exit(0);
    }
    else if(command.equals("Otwrz")){
      String fileName = showDialog(FileDialog.LOAD);
      if (fileName != null){
        load(fileName);
      }
    }
    else if (command.equals("Zapisz")){
      String fileName = showDialog(FileDialog.SAVE);
      if (fileName != null){
        save(fileName);
      }
    }
  }
  public String showDialog(int mode)
  {
    FileDialog fd = new FileDialog(this);
    fd.setMode(mode);
    fd.setVisible(true);
    String fileDir = fd.getDirectory();
    String fileName = fd.getFile();
    if(fileDir != null && fileName != null){
      return fileDir + fileName;
    }
    else{
      return null;
    }
  }
  public void load(String fileName)
  {
    String line = "";
    FileInputStream fin = null;
    File file = new File(fileName);
    try{
      fin = new FileInputStream(file);
    }
    catch(FileNotFoundException e){
      System.out.println("Brak pliku " + fileName);
      return;
    }
    DataInputStream out = new DataInputStream(fin);
    BufferedReader inbr = new BufferedReader(new InputStreamReader(fin));
    textArea.setText("");
    try{
      while ((line = inbr.readLine()) != null){
        textArea.append(line + '\n');
      }
    }
    catch(IOException e){
      System.out.println("Read/Write error.");
    }
  }
  public void save(String fileName)
  {
    FileOutputStream fout = null;
    File file = new File(fileName);
    try{
      fout = new FileOutputStream(file);
    }
    catch(FileNotFoundException e){
      System.out.println("Brak pliku " + fileName);
      return;
    }
    DataOutputStream out = new DataOutputStream(fout);
    try{
      String line = textArea.getText();
      out.writeBytes(line + '\n');
    }
    catch(IOException e){
      System.out.println("Read/Write error.");
    }
  }
  public static void main(String args[])
  {
    new HelloApp();
  }
  public void windowClosing(WindowEvent e)
  {
    System.exit(0);
  }
  public void windowClosed(WindowEvent e){}
  public void windowOpened(WindowEvent e){}
  public void windowIconified(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowActivated(WindowEvent e){}
  public void windowDeactivated(WindowEvent e){}
}
